# REVISITING AND ADVANCING FAST ADVERSARIAL TRAINING THROUGH THE LENS OF BI-LEVEL OPTIMIZATION

Code for paper [REVISITING AND ADVANCING FAST ADVERSARIAL TRAINING THROUGH THE LENS OF BI-LEVEL OPTIMIZATION]

## Prerequisites

- pytorch 1.5.1
- torchvision 0.6.1
- tqdm
- matplotlib
- numpy

## Usage

**Fast-AT**

You can run the following command to reproduce the result of Fast-AT on CIFAR-10 with PreActResNet-18 at $\epsilon = 8/255$ and $\epsilon = 16/255$ in our paper. You may change the random seed for different independent trails.

```shell
python train.py --mode fast_at --attack_eps 8 --attack_lr 10 --random_seed 0 --time_stamp fast_at_eps8_seed0
python train.py --mode fast_at --attack_eps 16 --attack_lr 20 --random_seed 0 --time_stamp fast_at_eps16_seed0
```

**PGD-2-AT**

You can run the following command to reproduce the result of PGD-2-AT on CIFAR-10 with PreActResNet-18 at $\epsilon = 8/255$ and $\epsilon = 16/255$ in our paper. You may change the random seed for different independent trials.

```shell
python train.py --mode pgd --attack_eps 8 --attack_lr 4 --attack_step 2 --random_seed 0 --time_stamp pgd2_eps8_seed0
python train.py --mode pgd --attack_eps 16 --attack_lr 8 --attack_step 2 --random_seed 0 --time_stamp pgd2_eps16_seed0
```

**Fast-AT-GA**

You can run the following command to reproduce the result of Fast-AT-GA on CIFAR-10 with PreActResNet-18 at $\epsilon = 8/255$ and $\epsilon = 16/255$ in our paper. You may change the random seed for different independent trials.

```shell
python train.py --mode fast_at_ga --attack_eps 8 --attack_lr 10 --random_seed 0 --ga_coef 0.2 --time_stamp fast_at_ga_eps8_seed0
python train.py --mode fast_at_ga --attack_eps 16 --attack_lr 8 --random_seed 0 --ga_coef 2.0 --time_stamp fast_at_ga_eps16_seed0
```

**Fast-BAT**

You can run the following command to reproduce the result of Fast-BAT on CIFAR-10 with PreActResNet-18 at $\epsilon = 8/255$ and $\epsilon = 16/255$ in our paper. You may change the random seed for different independent trials.

```shell
python train.py --mode fast_bat_kkt --attack_eps 8 --attack_lr 5000 --random_seed 0 --time_stamp fast_bat_eps8_seed0
python train.py --mode fast_bat_kkt --attack_eps 16 --attack_lr 2000 --random_seed 0 --time_stamp fast_bat_eps16_seed0
```

**Evaluation**

You can run the following command to evaluate the model with PGD-50-10 or AutoAttack by replacing the parameter "YOUR_MODEL_PATH" with the path of the to-be-evaluated model.

```shell
python evaluation.py --model_path YOUR_MODEL_PATH --eps 8 --attack_method PGD
python evaluation.py --model_path YOUR_MODEL_PATH --eps 8 --attack_method AutoAttack
```

